/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JPanel;
import net.nooj4nlp.engine.Graph;
import net.nooj4nlp.gui.shells.GrammarEditorShell;

public class JPGraph
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Graph grf;
    private GrammarEditorShell editor;

    public JPGraph(GrammarEditorShell shell) {
        this.editor = shell;
    }

    @Override
    protected void paintComponent(Graphics grphcs) {
        float ratioform;
        float ratiograph;
        Graphics2D g = (Graphics2D)grphcs;
        ArrayList<Graph> graphs = this.editor.getController().grammar.graphs;
        Font iFont = this.editor.getController().iFont;
        Font oFont = this.editor.getController().oFont;
        Font cFont = this.editor.getController().cFont;
        if (graphs == null || graphs.size() == 0) {
            this.displayEmptyGraph(g, iFont);
            return;
        }
        this.grf = graphs.get(this.editor.getController().current);
        if (this.grf == null) {
            this.displayEmptyGraph(g, iFont);
            return;
        }
        float scale = this.grf.fits == 1 ? ((ratiograph = 1.0f * (float)this.grf.size.width / (float)this.grf.size.height) <= (ratioform = 1.0f * (float)this.editor.pBackGraph.getWidth() / (float)this.editor.pBackGraph.getHeight()) ? 1.0f * (float)this.editor.pBackGraph.getHeight() / (float)this.grf.size.height : 1.0f * (float)this.editor.pBackGraph.getWidth() / (float)this.grf.size.width) : (float)this.grf.fits / 100.0f;
        this.grf.ifont = new Font(iFont.getFamily(), iFont.getStyle(), Math.round((float)iFont.getSize() * scale));
        this.grf.scale = this.grf.ifont.getSize2D() / iFont.getSize2D();
        this.grf.cfont = new Font(cFont.getFamily(), cFont.getStyle(), Math.round((float)cFont.getSize() * this.grf.scale));
        this.grf.ffont = new Font(iFont.getFamily(), iFont.getStyle(), Math.round((float)iFont.getSize() * scale));
        this.grf.ofont = new Font(oFont.getFamily(), oFont.getStyle(), Math.round((float)oFont.getSize() * scale));
        this.grf.vfont = new Font(iFont.getFamily(), iFont.getStyle(), Math.round((float)iFont.getSize() * scale * 2.0f));
        this.setSize(new Dimension((int)((float)this.grf.size.width * this.grf.scale), (int)((float)this.grf.size.height * this.grf.scale)));
        this.grf.paint(this, g, this.editor.getController().mouseM);
        if (this.editor.getController().SelectionRectangle.width != 0 && this.editor.getController().SelectionRectangle.height != 0) {
            g.setColor(this.editor.getController().grammar.sColor);
            float[] dash1 = new float[]{10.0f};
            BasicStroke dashed = new BasicStroke(2.0f, 0, 0, 10.0f, dash1, 0.0f);
            g.setStroke(dashed);
            Rectangle drawRectangle = this.editor.getController().computeRectangle(this.editor.getController().SelectionRectangle);
            g.draw(drawRectangle);
        }
        if (this.editor.getController().first_paint) {
            this.requestFocusInWindow();
            this.editor.getController().first_paint = false;
        }
        this.paintComponents(g);
        g.dispose();
    }

    private void displayEmptyGraph(Graphics2D g, Font iFont) {
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setStroke(new BasicStroke(2.0f));
        g.setColor(new Color(173, 216, 230));
        g.fillRect(0, 0, 800, 600);
        g.setColor(Color.RED);
        g.drawLine(0, 0, 800, 600);
        g.drawLine(800, 0, 0, 600);
        g.setFont(iFont);
        g.drawString("Graph does not exist", 20, 20);
    }
}

